/**
 * 
 */
package gov.va.med.mhv.integration.phr.service.cds;

import gov.va.med.mhv.cds.template.mhvintoleranceconditionread40011.ClinicalData;
import gov.va.med.mhv.integration.phr.service.ClinicalDataDocument;
import gov.va.med.mhv.integration.phr.service.ErrorSection;

/**
 * @author DNS
 *
 */
public class AllergyClinicalDataDocument implements ClinicalDataDocument {

	private ClinicalData allergyClinicalData = null;
	
	public AllergyClinicalDataDocument(ClinicalData allergyClinicalData) {
		if(allergyClinicalData == null) {
			throw new IllegalArgumentException("Allergy clinical data is null.");
		}
		this.allergyClinicalData = allergyClinicalData;
	}
	
	@Override
	public String getRequestedNationalId() {
		return this.allergyClinicalData.getPatient().get(0).getRequestedNationalId();
	}
	
	@Override
	public ErrorSection getErrorSection() {
		if(this.allergyClinicalData.getErrorSection() != null) {
			return new AllergyErrorSection(this.allergyClinicalData.getErrorSection());
		}
		
		return null;
	}
	
	@Override
	public Boolean isValid() {
		return (this.allergyClinicalData.getPatient().size() > 0 
				&& this.getRequestedNationalId() != null);
	}
	
	@Override
	public Object unwrap() {
		return this.allergyClinicalData;
	}
}
